﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Diagnostics;
using System.Collections.Generic;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

using GE.Gui;
using GE.Manager;
using GE.Visualisation;

namespace GE.Gui.Hud
{
    /// <summary>
    /// Head up display.
    /// </summary>
    class HeadUpDisplay
    {
        /// <summary>
        /// Unique instance of the HeadUpDisplay class.
        /// </summary>
        private static HeadUpDisplay _instance = new HeadUpDisplay();

        /// <summary>
        /// Position.
        /// </summary>
        private Vector2 _v2HealthPosition;

        /// <summary>
        /// Position of the boss' life bar
        /// </summary>
        private Vector2 _v2BossLifeBarPosition;

        /// <summary>
        /// Texture id
        /// </summary>
        private int _iIdTextureHUD;

        /// <summary>
        /// Life bar id
        /// </summary>
        private int _iIdSpriteLifeBar;

        /// <summary>
        /// Life mask id
        /// </summary>
        private int _iIdSpriteMaskLifeBar;

        /// <summary>
        /// Boss'es life bar id
        /// </summary>
        private int _iIdSpriteLifeBarBoss;

        /// <summary>
        /// Unique instance of the HeadUpDisplay class.
        /// </summary>
        public static HeadUpDisplay Instance
        {
            get
            {
                return _instance;
            }
        }

        /// <summary>
        /// Private constructor.
        /// </summary>
        private HeadUpDisplay()
        {
            _v2HealthPosition = new Vector2(20f);
            _v2BossLifeBarPosition = new Vector2(40, 20);
            _iIdTextureHUD = -1;
            _iIdSpriteLifeBar = -1;
            _iIdSpriteMaskLifeBar = -1;
            _iIdSpriteLifeBarBoss = -1;
        }

        /// <summary>
        /// Initialise the hud
        /// </summary>
        public void init()
        {
            _iIdTextureHUD = Visu.Instance.loadTilset("hud.xml");
            _iIdSpriteLifeBar = Visu.Instance.getSpriteId(_iIdTextureHUD, "life_bar");
            _iIdSpriteMaskLifeBar = Visu.Instance.getSpriteId(_iIdTextureHUD, "mask_life_bar");
            _iIdSpriteLifeBarBoss = Visu.Instance.getSpriteId(_iIdTextureHUD, "life_bar_boss");
        }


        /// <summary>
        /// Render the HUD.
        /// </summary>
        public void render()
        {
            Visu.Instance.displaySprite(_iIdTextureHUD, _iIdSpriteLifeBar, _v2HealthPosition);

            float ratio = (float)World.World.Instance.PlayerEntity.HP / (float)World.World.Instance.PlayerEntity.TotalHealthPoint;
            ratio = 1 - ratio;
            //if (ratio < 0) ratio = 0;
            if (ratio > 1) ratio = 1;
            Visu.Instance.displaySprite(_iIdTextureHUD, _iIdSpriteMaskLifeBar, _v2HealthPosition, Vector2.Zero, 0, new Vector2(1, ratio));
        }

        public void renderBossLifeBar(float totalHP, float currentHP)
        {
            Visu.Instance.displaySprite(_iIdTextureHUD, _iIdSpriteLifeBarBoss, _v2BossLifeBarPosition);

            float ratio = currentHP / totalHP;
            ratio = 1 - ratio;
            Visu.Instance.displaySprite(_iIdTextureHUD, _iIdSpriteMaskLifeBar, _v2BossLifeBarPosition, Vector2.Zero, 0, new Vector2(1, ratio));
        
        }

    }
}
